/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.peripherals;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.lib.peripherals.BoundMethod;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralPlugin;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntegrationPeripheral
implements IDynamicPeripheral {
    protected final List<IComputerAccess> connectedComputers = new ArrayList<IComputerAccess>();
    protected final List<BoundMethod> pluggedMethods = new ArrayList<BoundMethod>();
    protected boolean initialized = false;
    protected List<IPeripheralPlugin> plugins = null;
    protected String[] methodNames = new String[0];

    protected void buildPlugins() {
        if (!this.initialized) {
            this.initialized = true;
            this.pluggedMethods.clear();
            if (this.plugins != null) {
                this.plugins.forEach(plugin -> {
                    if (plugin.isSuitable((IPeripheral)this)) {
                        this.pluggedMethods.addAll(plugin.getMethods());
                    }
                });
            }
            this.methodNames = (String[])this.pluggedMethods.stream().map(BoundMethod::getName).toArray(String[]::new);
        }
    }

    protected void addPlugin(@NotNull IPeripheralPlugin plugin) {
        if (this.plugins == null) {
            this.plugins = new LinkedList<IPeripheralPlugin>();
        }
        this.plugins.add(plugin);
        IPeripheralOperation<?>[] operations = plugin.getOperations();
        if (operations != null) {
            throw new IllegalArgumentException("This is not possible to attach plugin with operations to not operationable owner");
        }
    }

    public List<IComputerAccess> getConnectedComputers() {
        return this.connectedComputers;
    }

    public void attach(@NotNull IComputerAccess computer) {
        this.connectedComputers.add(computer);
    }

    public void detach(@NotNull IComputerAccess computer) {
        this.connectedComputers.remove(computer);
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return iPeripheral == this;
    }

    @NotNull
    public @NotNull String @NotNull [] getMethodNames() {
        if (!this.initialized) {
            this.buildPlugins();
        }
        return this.methodNames;
    }

    @NotNull
    public MethodResult callMethod(@NotNull IComputerAccess access, @NotNull ILuaContext context, int index, @NotNull IArguments arguments) throws LuaException {
        if (!this.initialized) {
            this.buildPlugins();
        }
        return this.pluggedMethods.get(index).apply(access, context, arguments);
    }
}

